import string
class TechnologyReview(BasicNewsRecipe):
    title          = u'Technology Review'
    __author__ = 'rty'
    description = 'MIT Technology Magazine'
    publisher = 'Technology Review Inc.'
    category = 'Technology, Innovation, R&D'
    oldest_article = 14
    max_articles_per_feed = 100
    No_stylesheets = True
    extra_css = """
    .ArticleBody {font: normal; text-align: justify}
    .headline {font: bold x-large}
    .subheadline {font: italic large}
    """
    feeds = [
	(u'Computing', u'http://feeds.technologyreview.com/technology_review_Computing'),
	(u'Web', u'http://feeds.technologyreview.com/technology_review_Web'),
	(u'Communications', u'http://feeds.technologyreview.com/technology_review_Communications'),
	(u'Energy', u'http://feeds.technologyreview.com/technology_review_Energy'),
	(u'Materials', u'http://feeds.technologyreview.com/technology_review_Materials'),
	(u'Biomedicine', u'http://feeds.technologyreview.com/technology_review_Biotech'),
	(u'Business', u'http://feeds.technologyreview.com/technology_review_Biztech')
	] 
    remove_attributes = ['width', 'align','cellspacing']

    remove_tags = [
                    dict(name='div', attrs={'id':['CloseLink','footerAdDiv','copyright']}),
                         ]
    remove_tags_after = [dict(name='div', attrs={'id':'copyright'})]
    def get_article_url(self, article):
        return article.get('guid', article.get('id', None))


    def print_version(self, url):
        baseurl='http://www.technologyreview.com/printer_friendly_article.aspx?id=' 
        split1 = string.split(url,"/")
        xxx=split1 [4]
        split2= string.split(xxx,"/")  
        s =  baseurl + split2[0]
        return s
